use framework "Foundation"

set processName to "Hyve_VR_Cinema_v10"

set screenData to System_ScreenLayout()
if length of screenData is 2 then --2 monitors
	set screeninfo to item 2 of screenData
else if length of screenData is 3 then --3 monitors
	set screeninfo to item 3 of screenData
else
	set screeninfo to item 1 of screenData
end if

set targetDisplaySize to |size| of screeninfo
set {targetDisplayWidth, targetDisplayHeight} to {width of targetDisplaySize, height of targetDisplaySize}
set {originXofTargetDisplay, originYofTargetDisplay} to {x of origin of screeninfo, y of origin of screeninfo}

tell application "System Events" to tell process processName
	--set position of window 1 to {3000, 0}
	--set size of window 1 to {1500, 650}
	
	set position of window 1 to {originXofTargetDisplay, originYofTargetDisplay}
	set size of window 1 to {targetDisplayWidth, targetDisplayHeight}
end tell


on System_ScreenLayout()
	try
		set output to {}
		repeat with curScreen in current application's NSScreen's screens()
			set theFrame to curScreen's frame()
			if class of theFrame is record then
				set {origin:{x:theX, y:theY}, |size|:{width:theWidth, height:theHeight}} to theFrame
				set thisDisplay to the result
			else
				set {{theX, theY}, {theWidth, theHeight}} to theFrame
				set thisDisplay to {origin:{x:theX, y:theY}, |size|:{width:theWidth, height:theHeight}} -- the result
			end if
			copy thisDisplay to the end of the output
		end repeat
		return output
	on error errorText number errorNumber partial result errorResults from errorObject to errorExpectedType
		error "<System_ScreenLayout> " & errorText number errorNumber partial result errorResults from errorObject to errorExpectedType
	end try
end System_ScreenLayout